import logging

from celery.task import task
from wiki.async_operations.consts import OperationType, OperationIdentity, OperationOwner
from wiki.async_operations.operation_executors.base import BaseOperation
from wiki.async_operations.operation_executors.registry import EXECUTOR_REGISTRY
from wiki.async_operations.progress_storage import ASYNC_OP_PROGRESS_STORAGE
from ylog.context import log_context

logger = logging.getLogger(__name__)


def drf_view_schedule_execution(q: BaseOperation) -> str:
    q.check_preconditions()
    q.check_already_running(ASYNC_OP_PROGRESS_STORAGE)

    ASYNC_OP_PROGRESS_STORAGE.report_scheduled(q.get_task_identity(), q.owner)
    execute_async_operation.delay(
        task_type=q.TASK_TYPE, task_id=q.get_task_identity().id, args=q.args.dict(), owner=q.owner.dict()
    )

    return q.get_task_identity().id


@task(name='wiki.execute_async_operation')
def execute_async_operation(task_type: OperationType, task_id: str, args: dict, owner: dict):
    identity = OperationIdentity(type=task_type, id=task_id)
    with log_context(args=args, owner=owner, task_id=task_id, task_type=task_type):
        try:
            args = EXECUTOR_REGISTRY[OperationType(task_type)].arg_class.parse_obj(args)
            owner = OperationOwner.parse_obj(owner)

            async_operation = EXECUTOR_REGISTRY[task_type](args=args, owner=owner, task_id=task_id)

            logger.info(f'going to execute: "{task_type}" operation')
            async_operation.execute(ASYNC_OP_PROGRESS_STORAGE)
        except Exception as e:
            logger.exception(f'fail execute_async_operation: {e}')
            ASYNC_OP_PROGRESS_STORAGE.report_failure(identity, {'error': str(e)})
            raise e
