from typing import Type  # noqa

from wiki.async_process.backend.consts import AsyncTaskType
from wiki.async_process.backend.handlers.base import BaseJobHandler  # noqa
from wiki.async_process.backend.handlers.export import ExportJobHandler
from wiki.async_process.backend.handlers.move_cluster import MoveClusterJobHandler
from wiki.async_process.backend.handlers.test import TestJobHandler

job_handlers = {
    AsyncTaskType.EXPORT: ExportJobHandler,  # заглушка
    AsyncTaskType.TEST: TestJobHandler,
    AsyncTaskType.MOVE_CLUSTER: MoveClusterJobHandler,
}


def get_async_job_handler(task_type):  # type: (str) -> Type[BaseJobHandler]
    return job_handlers[AsyncTaskType(task_type)]
