
from django.contrib.auth import get_user_model

from wiki.async_process.backend.handlers.base import BaseJobHandler
from wiki.files.models import MDS_STORAGE
from wiki.org import org_ctx
from wiki.pages.logic.export import response_to_download_file, run_export_page
from wiki.pages.models import Page


class ExportJobHandler(BaseJobHandler):
    @classmethod
    def process_task(cls, task_data):
        page = Page.active.get(id=task_data['page_id'])
        output_format = task_data['output_format']
        with_subpages = task_data['with_subpages']
        user = get_user_model().objects.get(id=task_data['user_id'])
        cookies = task_data['cookies']

        with org_ctx(page.org):
            # сейчас тут заглушка - экспорт ничего не делает
            return run_export_page(user, output_format, with_subpages, as_stream=False, cookies=cookies)

    @classmethod
    def transform_result(cls, result):
        storage_key = result['storage_key']
        file_name = result['file_name']
        file_stream = MDS_STORAGE.open(storage_key).read()
        return response_to_download_file(file_stream, file_name)
