import logging

from django.contrib.auth import get_user_model

from wiki.async_process.backend.handlers.base import BaseJobHandler
from wiki.async_process.backend.handlers.utils import OrgCtxSafe
from wiki.async_process.serializers import AsyncResponse
from wiki.pages.logic.move import move_clusters

logger = logging.getLogger(__name__)


class MoveClusterJobHandler(BaseJobHandler):
    @classmethod
    def process_task(cls, task_data):
        """
        task_data должен иметь
        'user_id'
        'clusters' : dict - from -> to
        'with_children' : bool

        """
        user = get_user_model().objects.get(id=task_data['user_id'])

        with OrgCtxSafe(org_id=task_data['org_id']):
            status, data = move_clusters(user, task_data['clusters'], task_data['with_children'])

        return {'status': status, 'data': data}

    @classmethod
    def transform_result(cls, result):
        status = result['status']
        data = result['data']

        if not status == 200:
            msg = data.get('message', 'moving failed for pages')
            msg += ': '
            msg += ', '.join(data.get('pages', []))

            return AsyncResponse.from_failure({'message': msg})

        response = AsyncResponse.from_success()
        response.set_cookie('just_updated', 'true')

        return response
