
import logging

from django.conf import settings

from wiki.sync.connect.org_ctx import _ORG_CTX_KEY, raise_if_empty_org_ctx
from wiki.sync.connect.injector import absorb, get_from_thread_store, is_in_thread_store
from wiki.sync.connect.models import Organization


logger = logging.getLogger(__name__)


class OrgCtxSafe(object):
    """
    Универсальный враппер для функций что работают в б2б и интранете.
    Передаем org_id и не думаем.

    (...пока мы не отказались от thread_store и разделения логики...)
    """

    def __init__(self, org_id):

        self.org = None

        if settings.IS_BUSINESS and org_id is not None:
            self.org = Organization.objects.get(pk=org_id)

        raise_if_empty_org_ctx(self.org, 'Trying to put empty org in context')

    def __enter__(self):
        if not settings.IS_BUSINESS:
            return

        if not is_in_thread_store(_ORG_CTX_KEY):
            absorb(_ORG_CTX_KEY, [])

        ctx = get_from_thread_store(_ORG_CTX_KEY)
        ctx.append(self.org)

    def __exit__(self, exc_type, exc_val, exc_tb):
        if not settings.IS_BUSINESS:
            return

        ctx = get_from_thread_store(_ORG_CTX_KEY)
        ctx.pop()
