
import logging

from wiki.async_process.backend.handlers import get_async_job_handler

logger = logging.getLogger(__name__)


def process_async_request(task_type, task_data):
    """
    Обработка асинхронных запросов, запускаемая из Celery-задачи.
    """
    handler = get_async_job_handler(task_type)

    if 'cookies' in task_data:
        log_task_data = dict(task_data)
        del log_task_data['cookies']
    else:
        log_task_data = task_data

    logger.info('Processing request "%s" with data %s', task_type, log_task_data)
    return {'task_type': task_type, 'result': handler.process_task(task_data)}


def wrap_async_request_result(result):
    """
    Для некоторых типов асинхронных запросов, перед отдачей результата,
    сохраненного в Celery result backend, нужно его "обернуть".
    Например, для асинхронного запроса по экспорту файла мы отдаем не
    JSON с storage_id файла, а уже готовый поток байтов файла, StreamResponse.
    """
    handler = get_async_job_handler(result['task_type'])

    return handler.transform_result(result['result'])
