from enumfields.drf.fields import EnumField
from rest_framework import serializers
from rest_framework.response import Response

from wiki.async_process.consts import AsyncTaskStatus
from wiki.utils.backports.drf_jsonfield import JSONField


class AsyncRequestResultViewSerializer(serializers.Serializer):
    task_id = serializers.CharField(required=True)


class AsyncResponse(serializers.Serializer):
    status = EnumField(AsyncTaskStatus)
    data = JSONField(required=False)

    @classmethod
    def from_failure(cls, data=None):
        return Response(AsyncResponse({'status': AsyncTaskStatus.FAILED, 'data': data}).data)

    @classmethod
    def from_success(cls, data=None):
        return Response(AsyncResponse({'status': AsyncTaskStatus.SUCCESS, 'data': data}).data)

    @classmethod
    def not_finished(cls):
        return Response(AsyncResponse({'status': AsyncTaskStatus.PROCESSING}).data)
