
from celery.task import task
from rest_framework.response import Response

from wiki.async_process.backend.utils import process_async_request


def delay_async_request(task_type, task_data):
    async_result = async_request_processor.delay(task_type=task_type.value, task_data=task_data)
    return Response({'task_id': async_result.id}, status=201)


@task(name='wiki.async_request_processor')
def async_request_processor(task_type, task_data):
    return process_async_request(task_type, task_data)
