
from datetime import timedelta

from celery.task import task
from django_celery_results.models import TaskResult

from wiki.utils.timezone import now


@task(name='wiki.delete_stale_async_results')
def delete_stale_async_results():
    # Невостребованные результаты асинхронных задач автоматически удаляются через неделю.
    TaskResult.objects.filter(date_done__lt=now() - timedelta(weeks=1)).delete()
