
from wiki.sync.connect.admin import OrganizationAdmin
from wiki.billing.logic import update_org_stats


def update_billing_statistics(modeladmin, request, queryset):
    """
    Обновить статистику использования
    """
    update_org_stats(*list(queryset.values_list('id', flat=True)))


update_billing_statistics.short_description = 'Обновить статистику использования'

if not OrganizationAdmin.actions:
    actions = []
else:
    actions = list(OrganizationAdmin.actions)
actions.append(update_billing_statistics)
OrganizationAdmin.actions = tuple(actions)
