
from celery.utils.log import get_task_logger

from .logic import update_org_stats
from wiki.celery_apps import app
from wiki.utils.tasks.base import LockedCallableTask


class UpdateOrgStatsTask(LockedCallableTask):
    """
    Обновить статистику организаций.
    """

    name = 'wiki.update_org_stats'
    logger = get_task_logger(__name__)
    time_limit = 20 * 60

    def run(self, *args, **kwargs):
        update_org_stats()


app.tasks.register(UpdateOrgStatsTask)
