
# По конвеншену этот файл рекомендуется называть celery.py, но если сделать так, то при запуске тестов из PyCharm
# PythonPath оказывается настроен так, что `from celery import Celery` в этом файле пытается импортировать из себя,
# а не из системного пакета celery.


import os

from celery import Celery
from django.conf import settings
from django_tools_log_context.celery import CtxAwareMixin

from wiki.base_celery_task import CallableTask

# set the default Django settings module for the 'celery' program.
os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'wiki.settings')


class WikiCeleryTask(CtxAwareMixin, CallableTask):
    abstract = True


app = Celery('wiki', task_cls=WikiCeleryTask)

# Using a string here means the worker will not have to
# pickle the object when using Windows.
app.config_from_object('django.conf:settings', namespace='CELERY')
app.autodiscover_tasks(lambda: settings.INSTALLED_APPS)
