from wiki.api_core.errors.rest_api_error import RestApiError


class CloudsearchIsDownError(RestApiError):
    error_code = 'SEARCH_IS_UNAVAILABLE'
    debug_message = 'Cloudsearch is unavailable at the moment, please try again later'
    status_code = 503


class FormatterIsDownError(RestApiError):
    error_code = 'WFAAS_IS_UNAVAILABLE'
    debug_message = 'Wfaas is unavailable at the moment, please try again later'
    status_code = 503


class CloudsearchBadRequest(RestApiError):
    error_code = 'SEARCH_BAD_REQUEST'
    debug_message = 'You send bad request to cloudsearch'
    status_code = 400
