import logging

from typing import List, Set
from django.conf import settings
from wiki.cloudsearch.tvm_client import TvmServiceClient


logger = logging.getLogger(__name__)


class StaffApiClient(TvmServiceClient):
    TVM_CLIENT_ID = settings.STAFFAPI_TVM2_CLIENT_ID
    HOST = settings.STAFFAPI_HOST
    REMOTE_NAME = 'StaffAPI'

    def get_chief(self, login: str) -> Set[str]:
        def _parse(result: List[dict]) -> Set[str]:
            return {ans.get('chief', {}).get('login', '') for ans in result} - {''}

        response = self._call_api(
            endpoint='v3/persons', params={'login': login, '_fields': 'chief.login'}, method='get'
        )
        return _parse(response['result'])


STAFF_API_CLIENT = StaffApiClient()
