from wiki.cloudsearch.utils import reindex_all_org_via_sql
from wiki.utils.tasks.base import LockedCallableTask


class IndexOrganizationTask(LockedCallableTask):

    """
    Поставить организацию на индекс, если при поиске данная организация не была проиндексирована
    """

    name = 'wiki.index_organization'
    time_limit = 60 * 30  # 30 минут
    lock_name_tpl = 'index_organization_{org_id}'

    def run(self, org_id, *args, **kwargs):
        reindex_all_org_via_sql(org_id)
