import logging

from wiki.utils import api_request
from wiki.utils.tvm2 import get_service_ticket

logger = logging.getLogger(__name__)


class TvmServiceClient:
    TVM_CLIENT_ID = None
    HOST = None
    REMOTE_NAME = '?'

    @classmethod
    def _call_api(cls, endpoint, json=None, params=None, method='post', data=None, timeout=60):
        response = api_request.api_request(
            method=method,
            url=cls.HOST + endpoint,
            service_ticket=get_service_ticket(str(cls.TVM_CLIENT_ID)),
            json=json,
            params=params,
            data=data,
            headers={'Content-Type': 'application/json'},
            timeout=timeout,
            verify=False,
            retry_500=True,
            remote_name=cls.REMOTE_NAME,
        )
        return response.json()
