from wiki.api_core.framework import WikiAPIView
from wiki.api_core.raises import raises
from wiki.cloudsearch.utils import find_by_search_uuid, calculate_acl
from rest_framework.response import Response
from wiki.api_core.utils import TVMIDPermission
from django.conf import settings
import logging
from wiki.org import org_ctx


logger = logging.getLogger(__name__)


class TVMPermission(TVMIDPermission):
    tvm_client_ids = [settings.CLOUDSEARCH_TVM_CLIENT_ID]
    strict = True


class GetAcl(WikiAPIView):
    permission_classes = (TVMPermission,)  # Нужно, чтобы клиент микросервиса мог дерать эту ручку

    @raises()
    def post(self, request, *args, **kwargs):
        indexable_model = find_by_search_uuid(request.data['uuid'])
        with org_ctx(indexable_model.get_model_org()):
            return Response(calculate_acl(indexable_model.get_acl_subject()), 200)
