# Generated by Django 2.2.25 on 2021-12-12 14:09

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import wiki.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('pages', '0022_add_acl_mgmt'),
        ('connect', '0014_add_cloud_id'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('org', models.ForeignKey(
                    blank=True,
                    default=None,
                    null=True,
                    on_delete=django.db.models.deletion.CASCADE,
                    to='connect.Organization'
                )),
            ],
        ),
        migrations.CreateModel(
            name='Bookmark',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(default=wiki.utils.timezone.now)),
                ('page', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='pages.Page')),
                ('tags', models.ManyToManyField(to='favorites.Tag')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddConstraint(
            model_name='bookmark',
            constraint=models.UniqueConstraint(fields=('page', 'user'), name='favorites_bookmark_unique_page_user'),
        ),
        migrations.AddConstraint(
            model_name='tag',
            constraint=models.UniqueConstraint(
                fields=('name', 'user', 'org'), name='favorites_tag_unique_name_user_org'
            ),
        ),
    ]
