# Generated by Django 2.2.25 on 2021-12-22 08:44

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import enumfields.fields
import wiki.favorites.consts
import wiki.utils.timezone


class Migration(migrations.Migration):

    dependencies = [
        ('pages', '0022_add_acl_mgmt'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('favorites', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='AutoBookmark',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(default=wiki.utils.timezone.now)),
                ('bookmark_type', enumfields.fields.EnumField(
                    enum=wiki.favorites.consts.AutoBookmarkType, max_length=10
                )),
                ('page', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE,
                    related_name='favorites_autobookmark',
                    to='pages.Page'
                )),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddConstraint(
            model_name='autobookmark',
            constraint=models.UniqueConstraint(fields=('page', 'user'), name='favorites_autobookmark_unique_page_user'),
        ),
    ]
