from enumfields import EnumField
from django.conf import settings
from django.db import models

from wiki.favorites.consts import AutoBookmarkType
from wiki.pages.models import Page
from wiki.utils.timezone import now


class AutoBookmark(models.Model):
    # Вики страница, на которую ссылается закладка
    page = models.ForeignKey(Page, on_delete=models.CASCADE, related_name='favorites_autobookmark')

    # Владелец закладки
    user = models.ForeignKey(settings.AUTH_USER_MODEL, on_delete=models.CASCADE)

    # Дата создания закладки
    created_at = models.DateTimeField(default=now)

    # Тип автозакладки (создатель, редактор)
    bookmark_type = EnumField(AutoBookmarkType)

    def __str__(self):
        return f'AutoBookmark {self.id} for page "{self.page.slug}"'

    class Meta:
        constraints = [models.UniqueConstraint(fields=['page', 'user'], name='favorites_autobookmark_unique_page_user')]
