from django.conf import settings
from django.db import models

from wiki.favorites.models.tag import Tag
from wiki.pages.models import Page
from wiki.utils.timezone import now


class Bookmark(models.Model):
    objects: models.Manager

    # Вики страница, на которую ссылается закладка
    page = models.ForeignKey(Page, on_delete=models.CASCADE)

    # Владелец закладки
    user = models.ForeignKey(settings.AUTH_USER_MODEL, on_delete=models.CASCADE)

    # Дата добавления страницы в избранное
    created_at = models.DateTimeField(default=now)

    # Список тегов закладки
    tags = models.ManyToManyField(Tag)

    def __str__(self):
        return f'Bookmark {self.id} for page "{self.page.slug}"'

    class Meta:
        constraints = [models.UniqueConstraint(fields=['page', 'user'], name='favorites_bookmark_unique_page_user')]
