from django.conf import settings
from django.db import models

from wiki.sync.connect.models import Organization


class Tag(models.Model):
    id: int
    objects: models.Manager
    # Название тега
    name = models.CharField(max_length=50)

    # Владелец
    user = models.ForeignKey(settings.AUTH_USER_MODEL, on_delete=models.CASCADE)

    # Организация владельца
    org = models.ForeignKey(Organization, blank=True, null=True, default=None, on_delete=models.CASCADE)

    def __str__(self):
        return f'Tag {self.id}: "{self.name}"'

    class Meta:
        constraints = [
            models.UniqueConstraint(fields=['name', 'user', 'org'], name='favorites_tag_unique_name_user_org')
        ]
