import logging

from wiki.favorites.logic import update_autobookmarks
from wiki.utils.tasks.base import LockedCallableTask


class UpdateAutoBookmarksTask(LockedCallableTask):
    name = 'wiki.update_favorites_autobookmarks'
    logger = logging.getLogger(name)
    time_limit = 300
    lock_name_tpl = 'update_autobookmarks_{user_id}_{page_id}'

    def run(self, user_id, page_id, is_new_page):
        update_autobookmarks(user_id, page_id, is_new_page)
