from wiki.favorites.tasks import UpdateAutoBookmarksTask
from wiki.utils.db import on_commit


def update_autofolders(page, was_created: bool):
    if page.last_author.is_robot():
        return  # -- robots dont have autofolders --

    UpdateAutoBookmarksTask().delay(user_id=page.last_author.id, page_id=page.id, is_new_page=was_created)


def page_changed(page, was_created: bool):
    """
    Обновить закладки у пользователей после того, как страница была изменена.

    Для роботов и генерируемых тестовых пользователей (у них пока нет связи со staff)
    не ставим задачи в celery на обновление автопапок.
    """
    on_commit(lambda: update_autofolders(page, was_created))
