
from django.core.management.base import BaseCommand
from django.db import transaction
from wiki.favorites_v2.models import Folder, Bookmark, AutoBookmark


class Command(BaseCommand):
    """
    Это скорее всего разовая команда, вызванная рассинхронизацией числа закладок
    и поля favorites_count. WIKI-7678.
    """

    help = 'Sync Folder.favorites_count'

    def handle(self, *args, **options):
        folder_ids = Folder.objects.all().values_list('id', 'type')

        for id, folder_type in folder_ids:
            with transaction.atomic():
                print('folder with id', id)
                user_bookmarks_count = (
                    Bookmark.objects.filter(folder_id=id).count() if folder_type != Folder.FOLDER_TYPE_AUTO else 0
                )
                auto_bookmarks_count = (
                    AutoBookmark.objects.filter(folder_id=id).count() if folder_type == Folder.FOLDER_TYPE_AUTO else 0
                )
                Folder.objects.filter(id=id).update(favorites_count=user_bookmarks_count + auto_bookmarks_count)
