from django.core.management.base import BaseCommand
from django.db import transaction
from wiki.pages.models import Page
from wiki.favorites_v2.models import AutoBookmark
from wiki.utils.models import get_chunked


class Command(BaseCommand):
    """
    Разовая команда. Для заполнения поле "page" на основе "supertag" закладок для всех пользователей.
    WIKI-15699
    """

    help = 'AutoBookmark.supertag_to_page'

    def add_arguments(self, parser):
        parser.add_argument('--chunk-size', type=int, default=1000, help='Number of autobookmarks to change per cycle')

    def handle(self, *args, **options):
        autobookmarks = AutoBookmark.objects.filter(page=None).values_list('supertag', 'pk', named=True)
        for autobookmarks_chunk in get_chunked(autobookmarks, chunk_size=options.get('chunk-size', 1000)):
            with transaction.atomic():
                supertags = {a.supertag for a in autobookmarks_chunk}
                pages = Page.objects.filter(supertag__in=supertags).values_list('supertag', 'id')
                for supertag, page_id in pages:
                    AutoBookmark.objects.filter(supertag=supertag).update(page_id=page_id)
