from django.db import models

from wiki.pages.models import Page
from wiki.favorites_v2.models.fields import BigAutoField
from wiki.favorites_v2.models.folder import Folder


class AutoBookmark(models.Model):
    """
    Модель закладки для автопапок.
    По набору атрибутов от обычных закладок отличается только отсутствием index_number.
    """

    # ID задаем явно, ради BigInteger типа, так как в Integer (по-умолчанию) мы здесь не помещаемся.
    id = BigAutoField(primary_key=True)

    # Название закладки.
    title = models.CharField(max_length=500)

    # Ссылка на страницу закладки.
    url = models.CharField(max_length=1000)

    # Супертэг вики страницы.
    supertag = models.CharField(max_length=255, db_index=True)

    # Вики страница, на которую ссылается закладка
    page = models.ForeignKey(Page, null=True, on_delete=models.CASCADE)

    # Дата создания закладки.
    created_at = models.DateTimeField(auto_now_add=True)

    # Папка, к которой относится закладка.
    folder = models.ForeignKey(Folder, on_delete=models.CASCADE)

    # Дата последнего изменения вики страницы.
    page_modified_at = models.DateTimeField()

    # Автор последних изменений вики страницы.
    page_last_editor = models.CharField(max_length=30)

    def __str__(self):
        return 'id=%s  title=%s,  url=%s,  folder=%s,  supertag=%s' % (
            self.id,
            self.title,
            self.url,
            self.folder,
            self.supertag,
        )

    class Meta:
        app_label = 'favorites_v2'
