
from django.db import models

from wiki.favorites_v2.models.folder import Folder


class Bookmark(models.Model):
    """
    Модель закладки в пользовательском меню (Избранном).
    """

    # Название закладки.
    title = models.CharField(max_length=500)

    # Ссылка на страницу закладки
    url = models.CharField(max_length=1000)

    # Супертэг вики страницы. Значение обязательно для ссылок на вики страницы, для остальных должно отсутствовать.
    supertag = models.CharField(max_length=255, blank=True, null=True)

    # Дата создания закладки.
    created_at = models.DateTimeField(auto_now_add=True)

    # Папка, к которой относится закладка.
    folder = models.ForeignKey(Folder, on_delete=models.CASCADE)

    # Дата последнего изменения вики страницы.
    # Значение обязательно для ссылок на вики страницы, для остальных должно отсутствовать.
    page_modified_at = models.DateTimeField(blank=True, null=True)

    # Автор последних изменений вики страницы.
    # Значение обязательно для ссылок на вики страницы, для остальных должно отсутствовать.
    page_last_editor = models.CharField(max_length=30, blank=True, null=True)

    # Порядковый номер закладки в папке.
    index_number = models.IntegerField(default=0)

    def __str__(self):
        return 'id=%s  title=%s,  url=%s,  supertag=%s, folder={%s}' % (
            self.id,
            self.title,
            self.url,
            self.supertag,
            self.folder,
        )

    class Meta:
        app_label = 'favorites_v2'
