"""
Админские вьюшки, относящиеся к страницам
"""

from django.contrib.admin import ModelAdmin, site

from wiki.files.models import File


def restore_files_action(modeladmin, request, queryset):
    """
    Восстановить все выбранные файлы
    """
    from wiki.files import logic

    for file in queryset:
        logic.restore(file)


restore_files_action.short_description = 'Восстановить выбранные файлы'


class FileAdmin(ModelAdmin):
    """
    Настройки показа файлов в админке.
    """

    #
    # Список объектов
    #

    # поля, показываемые в списке файлов
    # тут нет 'page', так как WIKI-5991
    list_display = (
        'name',
        'created_at',
        'modified_at',
        'size',
        'url',
        'status',
    )
    # по кому искать из поисковой строки
    search_fields = (
        '=name',  # поиск ILIKE
        'url',  # ILIKE
        '=page__supertag',
    )
    list_per_page = 40
    # фильтры сбоку
    list_filter = []

    # Выключено, потому что WIKI-5990
    # иерархический фильтр по датам в шапке
    # date_hierarchy = 'created_at'

    # по клику на каких полях переходить на редактирование страницы
    list_display_links = ('name', 'url')

    actions = (restore_files_action,)

    #
    # Форма редактирования объекта
    #

    # исключить из формы редактирования страницы
    exclude = []

    # readonly поля на форме редактирования
    readonly_fields = (
        'url',
        'name',
        'page',
        'user',
        'mds_storage_id',
    )

    def get_actions(self, request):
        """
        Удалить из списка экшнов пункт "удалить выбранные"
        """
        actions = super(FileAdmin, self).get_actions(request)
        if 'delete_selected' in actions:
            del actions['delete_selected']
        return actions


site.register(File, FileAdmin)
