from datetime import datetime
from enum import Enum
from ninja import Schema
from typing import Optional


class ThumbnailStatus(str, Enum):
    UNKNOWN = 'unknown'
    SCHEDULED = 'scheduled'
    CREATED = 'created'
    NOT_AVAILABLE = 'not_available'
    FAILED = 'failed'


class ThumbnailFieldSchema(Schema):
    status: ThumbnailStatus
    changed_at: datetime = None
    s3_key: str = None

    def serialize(self):
        return {'s': self.status.value, 'c': self.changed_at.isoformat(), 'k': self.s3_key}

    @classmethod
    def deserialize(cls, o) -> 'ThumbnailFieldSchema':
        return cls(
            status=o['s'],
            changed_at=datetime.fromisoformat(o['c']),
            s3_key=o['k'],
        )


class ThumbnailModel(Schema):
    id: Optional[str]
    name: str
    s3_storage_key: str
    modified_at: datetime
    is_stored_on_s3: bool = True
