

from datetime import timedelta
from uuid import uuid4

from wiki.files.models import File
from wiki.utils import timezone


def delete(file):
    """
    Помечаем файл удаленным.

    Не используется напрямую, потому что delete в logic
    делает дополнительные манипуляции с данными — нужно использвоать его.
    """
    file.status = 0
    uuid_len = 5
    random_suffix = timezone.now().isoformat() + '|' + str(uuid4())[:uuid_len]
    file.url = 'deleted|' + file.url + '|' + random_suffix
    file.save()
    return file


def restore(file):
    """
    Вернуть файл к жизни вместе со старым урлом.
    """
    file.status = 1
    try:
        old_url, timestamp, hash = file.url[len('deleted|') :].rsplit('|', 2)
    except ValueError:
        # maybe something wrong with deleted file url
        old_url = file.url
    file.url = old_url
    file.save()
    return file


def create_delete_file_event(file, user, page=None):
    from wiki.notifications.models import PageEvent

    PageEvent.objects.create(
        timeout=timezone.now() + timedelta(minutes=5),
        page=page or file.page,
        author=user,
        meta={
            'filename': file.description or file.name,
            'url': file.url,
            'size': file.size,
            'id': file.id,
        },
        event_type=PageEvent.EVENT_TYPES.delete_file,
        notify=False,
    )


def clone_file(file, user, to_page):
    File(
        page=to_page,
        user=user,
        name=file.name,
        url=file.url,
        description=file.description,
        size=file.size,
        image_width=file.image_width,
        image_height=file.image_height,
        mds_storage_id=file.mds_storage_id,
    ).save()
    to_page.files += 1
    to_page.save()
