
from django.core.management.base import BaseCommand
from wiki.pages.models import Page
from wiki.files.models import File


class Command(BaseCommand):  # , ProcessDetector):
    help = 'Fix files_counter fields value in Page model'

    def handle(self, *args, **options):
        for page in Page.objects.iterator():
            cnt = File.active.filter(page=page).count()
            if cnt != page.files:
                page.files = cnt
                page.save()
