# flake8: noqa

# TODO(markg): Кешировать дерево
# TODO(markg): Оптимизировать вычислятор
"""\
    Этот пакет предоставляет функции для отфильтровывания строк в табличных
    списках, заданных пользователем в экшене {{grid}}

    Пример
        {{grid page="/Path/To/Grid" filter="13: in (10, 20)"}}

    Здесь необязательный параметр filter="..." задаёт условие, чтобы столбец
    с идентификатором 13 содержал значение равное 10 или 20. При вставке списка
    на странице отобразятся только строки, удовлетворяющие этому условию.

    Подробнее про синтаксис: http://wiki/wackowiki/projects/gridsfilters

    Файлы
        lexer.py        Разбор параметра filter="..." на лексемы
        parser.py       Создание дерева условий по данному параметру filter="..."
        evaluator.py    Отбор строк из конкретного грида, используя
                        дерево условий
        semantictree.py Классы и хелперы для построения дерева условий

    Пример использования

        from wiki.grids.filter import filter_grid, FilterError

        grid = ...  # get some grid
        try:
            hashes_in, hashes_out = filter_grid("13: in (10, 20)", grid)
        except FilterError:
            # ... handle errors ...
        rows_in = grid.get_rows(request, hashes_in)

"""

import re

from wiki.grids.filter.base import FilterError
from wiki.grids.filter.evaluator import assert_columns_exist, evaluate
from wiki.grids.filter.parser import parse


def filter_grid(filter_text, grid, hashes=None):
    semantic_tree = parse(filter_text)
    hashes_in, hashes_out = evaluate(semantic_tree, grid, hashes=hashes)
    return hashes_in, hashes_out


def is_filtered_out(filter_text, grid, row_hash):
    _, hashes_out = filter_grid(filter_text, grid, hashes=[row_hash])
    return row_hash in hashes_out


def get_column_names(column_filter_text):
    return re.findall(r'\[?([^\]\s,]+)\]?', column_filter_text)


def get_filter_parts(filter_text):
    parts = {}
    for part in filter_text.split(','):
        match = re.search(r'\[([^\]]+)\]', part)
        if match:
            column = match.group(1)
            parts.setdefault(column, [])
            parts[column].append(part.strip())
    return dict([column, ', '.join(parts[column])] for column in parts)
