

from collections import namedtuple


Value = namedtuple('Value', 'type,value')
Condition = namedtuple('Condition', 'column,operator,args,negated')
Combinator = namedtuple('Combinator', 'operator,args,negated')


def NOT(condition):
    return condition._replace(negated=not condition.negated)


def EQUAL(column, args):
    return Condition(column, 'EQUAL', args, negated=False)


def CONTAINS(column, args):
    return Condition(column, 'CONTAINS', args, negated=False)


def LESS(column, args):
    return Condition(column, 'LESS', args, negated=False)


def AND(*args):
    return Combinator('AND', list(args), negated=False)


def OR(*args):
    return Combinator('OR', list(args), negated=False)
