
from django.db.models import Q

from wiki.org import org_staff


def get_grid_concurrent_changes(grid, version, user):
    """
    Возвращает обзор изменений грида, произошедших после указанной версии.
    Сейчас это список пользователей (инстансов User), изменивших грид.

    @type grid: Grid
    @type revision_id: int
    @type user: User
    @rtype: list
    """
    editor_ids = (
        grid.revision_set.select_related('author')
        .filter(~Q(author=user), id__gt=version)  # версия грида совпадает с id ревизии
        .values_list('author')
        .distinct()
    )

    editors = org_staff().filter(user_id__in=editor_ids).values('uid', 'login', 'first_name', 'last_name')

    return {'editors': editors}
