
from json import dumps
from random import randint

from django.utils.translation import ugettext

from wiki.grids.readers import CsvReader
from wiki.grids.utils import dummy_request_for_grids, insert_rows, make_beautiful_structure_from


def import_pipeline(row_iter, column_names, limit_rows=None):
    for row in row_iter:
        yield {name: col_value for name, col_value in zip(column_names, row)}
        if limit_rows:
            limit_rows -= 1
            if limit_rows <= 0:
                break


def import_csv(grid, csv_data, limit_rows=None, use_first_as_header=True, omit_first=0, delimiter=';', quotechar='\"'):
    """
    Хелпер для импорта csv таблицы для работы из консоли.
    Я вытащил минимальный объем кода для импорта текстового контента в новый (!) грид.
    Пример использования см в ReduxTest
    :param grid: Grid
    :param csv_data: str
    :param limit_rows: int
    :param use_first_as_header: bool
    :param omit_first: bool
    :param delimiter:
    :param quotechar:
    :return:
    """
    grid_reader = CsvReader(csv_data, omit_first=omit_first, delimiter=delimiter, quotechar=quotechar)
    grid_reader.open()

    grid_fields = []

    column_grid_map = {}

    csv_column_count = grid_reader.column_count

    imported_column_count = 0

    row_iter = iter(grid_reader)

    if use_first_as_header:
        header_names = next(row_iter)
    else:
        header_names = [ugettext('grids.import:column %s') % imported_column_count for i in range(csv_column_count)]

    names = []
    for column_indx in range(csv_column_count):
        grid_column_name = str(randint(100, 1000))
        column_grid_map[column_indx] = grid_column_name

        imported_column_count += 1
        column_type = 'string'

        names.append(grid_column_name)

        column_description = {
            'type': column_type,
            'name': grid_column_name,
            'title': header_names[column_indx],
        }

        if column_type in ('multiple_staff', 'multiple_select'):
            column_description['multiple'] = True
            column_description['type'] = column_description['type'][len('multiple_') :]
        if column_type in ('select', 'multiple_select'):
            column_description['options'] = []

        grid_fields.append(column_description)

    structure = {'structure': {'fields': grid_fields}}
    structure = make_beautiful_structure_from(dumps(structure))['structure']

    grid.change_structure(None, structure)
    request = dummy_request_for_grids()
    insert_rows(grid, import_pipeline(row_iter, names, limit_rows), request=request, after='last')

    # max_lines_to_import = MAX_LINES_TO_IMPORT
    # # inserted_rows = import_data_to_grid(grid, grid_reader, column_grid_map, max_lines_to_import, **params)
    #
    # return inserted_rows, preview_data, imported_column_count > 0
