

from wiki.legacy.choices import Choices

from django.conf import settings


ticket_field_names = Choices(
    assignee='ticket-assignee',
    reporter='ticket-reporter',
    status='ticket-status',
    priority='ticket-priority',
    type='ticket-type',
    subject='ticket-subject',
    updated_at='ticket-updatedat',
    created_at='ticket-createdat',
    original_estimation='ticket-originalestimation',
    fix_versions='ticket-fixversions',
    components='ticket-components',
    story_points='ticket-storypoints',
)

ticket_dependent_types = [field[0] for field in ticket_field_names.choices()]


def is_tracker_ticket_field(grid, field_name):
    """
    @type grid: Grid
    """
    if not settings.ISSUE_TRACKERS_ENABLED:
        return False
    field = grid.column_by_name(field_name)
    return field and field['type'] in ticket_dependent_types
