"""
Обертка над ревизиями, имитирующая интерфейс табличных списков.
"""

from wiki.pages.models import Revision as OriginalRevision
from wiki.grids.utils.grid_interface import GridInterfaceMixin


class Revision(OriginalRevision, GridInterfaceMixin):
    class Meta:
        proxy = True


def get_version_of_grid(version):
    """
    Вернуть версию грида по переданной версии.

    @type version: str
    @rtype: Revision
    @raise: DoesNotExist
    """
    return Revision.objects.get(id=version)
