from typing import Type

from django.utils.translation import ugettext

from wiki.grids.readers.csvreader import CsvReader
from wiki.utils.wiki_markup import SubstitureFormattingString

reader_map = {
    'csv': CsvReader,
    'txt': CsvReader,
}


def reader(extension) -> Type[CsvReader]:
    return reader_map[extension]


def mapped_reader(row_map, reader, format_strings=True):
    text_substitute = ugettext('grids.import:will appear in a few minutes')
    for row in reader:
        mapped_row = dict(
            [
                (row_map[idx], row[idx] if format_strings else dont_format_strings(row[idx], text_substitute))
                for idx in row_map
            ]
        )  # == {value: ...тернарный оператор... for idx, value in row_map.items()}
        yield mapped_row


def dont_format_strings(value, substitute):
    if value:
        skip_format = SubstitureFormattingString(value)
        skip_format.substitute = value
        return skip_format
    return value
