
import csv

from wiki.grids.readers.base import BaseReader


class CsvReader(BaseReader):
    def __init__(self, contents, omit_first=0, **kwargs):
        self.lines = contents.splitlines()  # TODO: переделать тут все, чтобы принимало stream'ы
        self.kwargs = kwargs
        self.omit_first = omit_first

    def open(self):
        self.reader = csv.reader(self.lines, dialect='excel-tab', **self.kwargs)
        return self

    def __iter__(self):
        # Нужно сразу вычислить column_count, что не делать повторный open потом
        cols = self.column_count

        omitted = 0
        for row in self.reader:
            if omitted < self.omit_first:
                omitted += 1
                continue
            if row:
                if cols > len(row):
                    row += [''] * (cols - len(row))
                yield row

    @property
    def row_count(self):
        return len(self.lines) - self.omit_first

    @property
    def column_count(self):
        if hasattr(self, '_column_count'):
            return self._column_count
        self._column_count = 0
        m = 0
        cnt = 0
        omitted = 0
        for row in self.reader:
            if omitted < self.omit_first:
                omitted += 1
                continue
            if row:
                m = max(len(row), m)
                cnt += 1
            if cnt > 100:
                break
        self._column_count = m

        # при определении column_count вычитываются все строки, поэтому делаем open еще раз
        self.open()

        return m
