import yaml
import json
from wiki.actions.classes.form_elements.mapper import build_form


def unserialize_json(text):
    if text is None:
        result = {}
    else:
        if text:
            result = json.loads(text)
        else:
            result = {}
    keys = ('structure', 'idx')
    for key in keys:
        if key not in result:
            result[key] = {}
    if 'data' not in result:
        result['data'] = []
    if 'meta' not in result:
        result['meta'] = {
            'autoincrement': 0,
        }
    return result


def value_to_type(value, to_type):
    pass


def make_beautiful_structure_from(ugly_structure):
    """Specify missing fields with default values

    ugly_structure is JSON
    """
    json = unserialize_json(ugly_structure)
    beautiful_structure = json['structure']
    if 'done' not in beautiful_structure:
        beautiful_structure['done'] = False
    if 'fields' not in beautiful_structure:
        beautiful_structure['fields'] = []
    default_field_values = {
        'type': 'string',
        'required': False,
    }
    for description in beautiful_structure['fields']:
        for option in default_field_values:
            if option not in description:
                description[option] = default_field_values[option]
        if description['type'] == 'select':
            if 'multiple' not in description:
                description['multiple'] = False
        elif description['type'] == 'staff':
            if 'multiple' not in description:
                description['multiple'] = False
            if 'format' not in description:
                description['format'] = 'first_name last_name'
        elif description['type'] == 'date':
            if 'format' not in description:
                description['format'] = 'd.m.Y'
        elif description['type'] == 'number':
            if 'format' not in description:
                description['format'] = '%.2f'
    return json


def serialize_structure(someobject):
    def correct(structure):
        result = {'fields': {}}
        fields = result['fields']
        for field in structure['fields']:
            fields.update(field)
        return result

    structure = someobject['structure']
    yaml_result = yaml.dump(correct(structure))
    if 'fields' in structure:
        form = build_form(source=yaml_result)
        form_fields = {}
        for field in form:
            form_fields[field.name] = str(field)
        for field in structure['fields']:
            name, description = list(field.items())[0]
            if name in form.fields:
                description['input'] = form_fields[name]
    return json.dumps(someobject)


def unserialize_meta(ugly_meta):
    json = unserialize_json(ugly_meta)
    if 'autoincrement' not in json:
        json['autoincrement'] = 0
    return json
