
from django.template.loader import render_to_string

from wiki.grids.utils.view import grid_as_table


def static_grid_params(grid_structure, grid_data, width=None, enumerate=True, sort=True):
    columns, rows = grid_as_table(grid_structure, grid_data, do_sort=True)
    params = {
        'columns': columns,
        'rows': rows,
        'gridwidth': width or grid_structure.get('width'),
        'enumerate': enumerate,
        'sort': sort,
    }
    return params


def static_grid(grid_structure, grid_data, request, params, width=None, enumerate=True, sort=True):
    params.update(static_grid_params(grid_structure, grid_data, width, enumerate, sort))
    if not params.get('grid_supertag') and request.page:
        params['grid_supertag'] = request.page.supertag

    return render_to_string('actions/static_grid.html', params, request=request)
