
import re
from wiki.legacy.translate import Translator

grid_translator = Translator()

#    Everything inside <pre>
grid_translator.prepend_escape_pattern(re.compile(r'<pre.*?>.*?<\/pre>', re.S))

#    Usernames as in staff:markg
grid_translator.prepend_escape_pattern(re.compile(r'<a[^>]*class="[^"]*auto-person-card.*?</a>'))

# <span class="b-user-raw>
grid_translator.prepend_escape_pattern(re.compile(r'<span[^>]*class="[^"]*b-user-raw.*?</span>'))

# Everything that goes inside ##...## and %%...%% oneliners
grid_translator.prepend_escape_pattern(re.compile(r'<tt>.*?</tt>'))

#    Inline code: %%(code inline) ... %%
grid_translator.prepend_escape_pattern(re.compile(r'<code[^>]*>.*?</code>'))

# ...Here we cut any html tags with default escape regexp and proceed:

#    Logins and maillists as in tools@
grid_translator.append_escape_pattern(re.compile(r'[\w-]+@'))

#    Slashes in wiki links /page/subpage
grid_translator.append_escape_pattern(re.compile(r'&nbsp;/&nbsp;'))

#    Backslashes as in \\miracle\fish\whale
grid_translator.append_escape_pattern(re.compile(r'\\\\([\w.:-]+\\?)*'))

#    Html entities: &mdash;, &amp; etc
grid_translator.append_escape_pattern(re.compile(r'&\w+;'))
