import django.contrib.postgres.fields.jsonb
import django.db.models.deletion
import uuid

import wiki.inline_grids.models
import wiki.utils.s3.storage

from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('pages', '0028_refactor_cluster_change'),
    ]

    operations = [
        migrations.CreateModel(
            name='Grid',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('title', models.CharField(default='', max_length=255)),
                ('structure', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True)),
                ('s3_key', models.FileField(
                    max_length=200,
                    null=True,
                    storage=wiki.utils.s3.storage.S3Storage(),
                    upload_to=wiki.inline_grids.models.upload_to,
                )),
                ('page', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='pages.Page')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
