import uuid

from django.contrib.postgres.fields import JSONField
from django.db import models

from wiki.pages.models import Page
from wiki.pages.models.json_props import SerializedPropsMixin
from wiki.utils.s3.storage import S3_STORAGE


def upload_to(instance, filename):
    return True


class Grid(SerializedPropsMixin, models.Model):
    objects: models.Manager
    id = models.UUIDField(primary_key=True, default=uuid.uuid4)

    # Вики страница, которой принадлежит грид
    page = models.ForeignKey(Page, on_delete=models.CASCADE)

    # Название
    title = models.CharField(max_length=255, default='')

    # Структура грида в формате GridStructureSchema
    structure = JSONField(null=True, blank=True)

    s3_key = models.FileField(max_length=200, storage=S3_STORAGE, upload_to=upload_to, null=True)

    _serialized_props = (
        # Данные в формате GridRowSchema
        'raw_data',
    )

    _storage_field_name = 's3_key'

    def __str__(self):
        return f'Grid {self.id} on page "{self.page.slug}"'

    @property
    def rows(self):
        if not self.raw_data:
            return []
        return self.raw_data

    @property
    def columns(self):
        return self.structure['fields']
