
from abc import ABCMeta, abstractmethod
from contextlib import contextmanager


class BaseDocRetriever(object, metaclass=ABCMeta):
    user_ticket = None

    @contextmanager
    def user_identity(self, user_ticket):
        self.user_ticket = user_ticket
        yield
        self.user_ticket = None

    @abstractmethod
    def ensure_access(self, supertag, login, check_first=True):
        pass

    @abstractmethod
    def provision_page(self, acls):
        pass

    @abstractmethod
    def check_access(self, login, domain, namespace, sourcedoc):
        pass

    @abstractmethod
    def resolve_url(self, url):
        """
        Resolves url to cloud document.

        :return: dictionary of document attributes

        Пример ответа:
        %%(js)
        {
            'driveitem': {
                'drive_id': 'b!R1UocfNXyU6bFmI8Bc5GDLERVSUjmrJKri57nSGRHnMpTM39UhheSJD3jlShBohv"',
                'item_id': '01CFXCC6GQ3SD3TP75RBHI53TDAILEMBEL',
            },
            'document': {
                'type': 'pptx',
                'filename': 'Demo_Sprint_Kholodoque.pptx',
                'relative_path': '/My_Presetations',
            },
            'embedding': {
                'domain': 'yandexteam.sharepoint.com',
                'namespace': 'sites/wiki-dev',
                'sourcedoc': '{B987DCD0-FDBF-4E88-8EEE-63021646048B}'
            }
        }
        %%
        """

    @abstractmethod
    def create_new_document(self, url):
        """
        Creates new document in cloud by given url.
        Format of url value: "(wiki_prefix)/(supertag).(filetype)"

        :return: dictionary of document attributes

        Пример ответа:
        %%(js)
        {
            'driveitem': {
                'drive_id': 'b!R1UocfNXyU6bFmI8Bc5GDLERVSUjmrJKri57nSGRHnMpTM39UhheSJD3jlShBohv"',
                'item_id': '01CFXCC6GQ3SD3TP75RBHI53TDAILEMBEL',
            },
            'document': {
                'type': 'pptx',
                'filename': 'Demo_Sprint_Kholodoque.pptx',
                'relative_path': '/My_Presetations',
            },
            'embedding': {
                'domain': 'yandexteam.sharepoint.com',
                'namespace': 'sites/wiki-dev',
                'sourcedoc': '{B987DCD0-FDBF-4E88-8EEE-63021646048B}'
            }
        }
        %%
        """

    @abstractmethod
    def prepare_upload(self, url):
        """ """

    @abstractmethod
    def finalize_upload(self, upload_url, signature):
        """ """
