from enum import Enum

from pydantic import BaseModel


class Ms365DocType(str, Enum):
    DOCX = 'docx'
    PPTX = 'pptx'
    XLSX = 'xlsx'


class DocCreationSourceType(Enum):
    FROM_URL = 'from_url'
    EMPTY_DOC = 'empty_doc'
    UPLOAD_DOC = 'upload_doc'


class DocumentAccessLevel(Enum):
    NO_ACCESS = 'denied'
    READ_WRITE = 'read_write'
    READ = 'read'


DOC_CREATION_METHOD_PARAMS_MAP = {
    DocCreationSourceType.FROM_URL: 'url',
    DocCreationSourceType.EMPTY_DOC: 'doctype',
    DocCreationSourceType.UPLOAD_DOC: 'mime',
}


class DriveItem(BaseModel):
    drive_id: str
    item_id: str


class Document(BaseModel):
    type: Ms365DocType
    filename: str
    relative_path: str


class Embedding(BaseModel):
    domain: str
    namespace: str
    sourcedoc: str


class SharepointCloudSrc(BaseModel):
    driveitem: DriveItem
    document: Document
    embedding: Embedding
