from wiki.api_core.errors.rest_api_error import RestApiError


class AppIsUnauthorized(Exception):
    pass


class MsApiCallFailed(Exception):
    pass


class AuthFailed(RestApiError):
    error_code = 'MS365_AUTH_FAILED'
    debug_message = 'Failed to authorize'


class Ms365AuthRequired(RestApiError):
    error_code = 'MS365_AUTH_REQUIRED'
    debug_message = 'User must authorize app first'


class Ms365AccessDenied(RestApiError):
    error_code = 'MS365_ACCESS_DENIED'
    status_code = 403
    debug_message = 'Our bot can not access the shared link'


class Ms365NotFound(RestApiError):
    error_code = 'MS365_ITEM_NOT_FOUND'
    status_code = 404
    debug_message = 'Document not found in ms365'


class EnsureAccessDenied(RestApiError):
    error_code = 'ENSURE_ACCESS_TO_UNMANAGED_ACL_FORBIDDEN'
    status_code = 403
    debug_message = 'Can not ensure user access to unmanaged acl'


class Ms365NotDocx(RestApiError):
    error_code = 'MS365_NOT_DOCX'
    debug_message = 'Shared link must contain Docx'


class Ms365BadLink(RestApiError):
    error_code = 'MS365_BAD_LINK'
    debug_message = 'Link doesnt look like ms365'


class ExpectingContentRangeHeader(RestApiError):
    error_code = 'BLACKHOLE'
    debug_message = 'Content-Range header must be provided'


class Ms365BadFormat(RestApiError):
    error_code = 'MS365_BAD_FORMAT'
    debug_message = 'File type is not in docx|pptx|xlsx'


class Ms365GenericApiFailure(RestApiError):
    error_code = 'MS365_API_FAILURE'
    status_code = 500
    debug_message = 'Ms 365 api failure'


class Ms365BadUploadSession(RestApiError):
    error_code = 'MS365_BAD_UPLOAD_SESSION'
    status_code = 409
    debug_message = 'Upload session for the GUID does not exist'


class Ms365FinalizationFailed(RestApiError):
    error_code = 'MS365_FINALIZATION_FAILED'
    status_code = 409
    debug_message = 'Finalization Failed. Probably empty file'


class Ms365BadSignature(RestApiError):
    error_code = 'MS365_BAD_SIGNATURE'
    status_code = 500
    debug_message = 'Retriever rejected our signature'


class Ms365HtmlConvertError(RestApiError):
    error_code = 'MS365_HTML_CONVERT_ERROR'
    status_code = 400
    debug_message = 'Document cannot be converted'


class EnsureAccessFailed(RestApiError):
    error_code = 'ENSURE_ACCESS_UNSUCCESSFUL'
    status_code = 400
    debug_message = 'Ensure Access was unsuccessful'


class Ms365BadDownloadUrl(RestApiError):
    error_code = 'MS365_BAD_DOWNLOAD_URL'
    status_code = 500
    debug_message = 'Retriever could not download document'


class TokenExpired(MsApiCallFailed):
    pass


class MsApiBadRequest(MsApiCallFailed):
    pass


class MsApiRequestFailed(MsApiCallFailed):
    pass
