import uuid
from enum import Enum

from django.conf import settings
from django.db import models
from enumfields import EnumField


class Ms365AccountTypes(Enum):
    USER = 'user'
    SERVICE = 'svc'


class AppAuthorization(models.Model):
    account_type = EnumField(Ms365AccountTypes, default=Ms365AccountTypes.USER)
    user = models.ForeignKey(settings.AUTH_USER_MODEL, blank=True, null=True, on_delete=models.CASCADE)
    webauth_required = models.BooleanField(default=True)
    oauth2_state = models.CharField(max_length=1024, blank=True, null=True)
    access_token = models.TextField(default='')
    refresh_token = models.TextField(default='')
    expires_at = models.DateTimeField(null=True)
    refreshed_at = models.DateTimeField(null=True)

    def rotate_state(self, save=True):
        self.oauth2_state = '%s:%s' % (uuid.uuid4(), self.pk)
        if save:
            self.save(update_fields=('oauth2_state',))
        return self.oauth2_state

    @classmethod
    def get_service_account(cls):
        acc, _ = cls.objects.get_or_create(account_type=Ms365AccountTypes.SERVICE)
        return acc
