def parse_http_range(range_header):
    """
    rfc7233.txt
    """

    _, brange_0 = range_header.split(' ')
    brange, size = brange_0.split('/')
    start, finish = brange.split('-', 1)
    start = int(start)
    finish = int(finish)

    if start > finish:
        return False

    if size == '*':
        return False
    size = int(size)
    if finish >= size:
        return False

    return True
